<?php
/**
 * Admin Panel Sayfası
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap koruma-admin">
    <div class="koruma-header">
        <h1 class="koruma-title">
            <span class="koruma-icon">🛡️</span>
            <?php _e('KORUMA Güvenlik Merkezi', 'koruma'); ?>
        </h1>
        <p class="koruma-subtitle"><?php _e('WordPress sitenizi virüslerden ve saldırılardan koruyun', 'koruma'); ?></p>
    </div>

    <!-- Koruma Durumu -->
    <div class="koruma-card koruma-status-card">
        <div class="koruma-card-header">
            <h2><?php _e('Koruma Durumu', 'koruma'); ?></h2>
        </div>
        <div class="koruma-card-body">
            <div class="koruma-status-toggle">
                <div class="koruma-status-indicator <?php echo $protection_status ? 'active' : 'inactive'; ?>">
                    <span class="status-icon"><?php echo $protection_status ? '🔒' : '🔓'; ?></span>
                    <span class="status-text" id="koruma-status-text">
                        <?php echo $protection_status ? __('Koruma AÇIK', 'koruma') : __('Koruma KAPALI', 'koruma'); ?>
                    </span>
                </div>
                <button type="button" 
                        class="koruma-toggle-btn <?php echo $protection_status ? 'active' : ''; ?>" 
                        id="koruma-toggle-btn"
                        data-status="<?php echo $protection_status ? 'on' : 'off'; ?>">
                    <span class="toggle-slider"></span>
                    <span class="toggle-label"><?php echo $protection_status ? __('KAPAT', 'koruma') : __('AÇ', 'koruma'); ?></span>
                </button>
            </div>
            <p class="koruma-status-desc">
                <?php if ($protection_status): ?>
                    <?php _e('Koruma aktif. Dosya değişiklikleri engelleniyor ve tüm aktiviteler loglanıyor.', 'koruma'); ?>
                <?php else: ?>
                    <?php _e('Koruma kapalı. Dosya değişikliklerine izin veriliyor. Güvenlik için korumayı açmanız önerilir.', 'koruma'); ?>
                <?php endif; ?>
            </p>
        </div>
    </div>

    <!-- Kullanıcı Ekleme Kilitleme -->
    <div class="koruma-card koruma-user-lock-card">
        <div class="koruma-card-header">
            <h2><?php _e('Kullanıcı Ekleme Kilitleme', 'koruma'); ?></h2>
        </div>
        <div class="koruma-card-body">
            <div class="koruma-status-toggle">
                <div class="koruma-status-indicator <?php echo $user_creation_locked ? 'active' : 'inactive'; ?>">
                    <span class="status-icon"><?php echo $user_creation_locked ? '🔒' : '🔓'; ?></span>
                    <span class="status-text" id="koruma-user-lock-text">
                        <?php echo $user_creation_locked ? __('Kullanıcı Ekleme KİLİTLİ', 'koruma') : __('Kullanıcı Ekleme AÇIK', 'koruma'); ?>
                    </span>
                </div>
                <button type="button" 
                        class="koruma-toggle-btn <?php echo $user_creation_locked ? 'active' : ''; ?>" 
                        id="koruma-user-lock-btn"
                        data-status="<?php echo $user_creation_locked ? 'on' : 'off'; ?>">
                    <span class="toggle-slider"></span>
                    <span class="toggle-label"><?php echo $user_creation_locked ? __('AÇ', 'koruma') : __('KİTLET', 'koruma'); ?></span>
                </button>
            </div>
            <p class="koruma-status-desc">
                <?php if ($user_creation_locked): ?>
                    <strong style="color: #dc3545;"><?php _e('⚠️ KİLİTLİ:', 'koruma'); ?></strong>
                    <?php _e('Yeni kullanıcı eklenemez. Hem admin panelinden hem de frontend kayıt formundan kullanıcı ekleme engellenmiştir. Saldırı durumunda bile yeni kullanıcı oluşturulamaz.', 'koruma'); ?>
                <?php else: ?>
                    <strong style="color: #28a745;"><?php _e('✓ AÇIK:', 'koruma'); ?></strong>
                    <?php _e('Kullanıcı ekleme aktif. Yeni kullanıcılar eklenebilir. Güvenlik için kilitlemeyi açmanız önerilir.', 'koruma'); ?>
                <?php endif; ?>
            </p>
        </div>
    </div>

    <!-- İstatistikler -->
    <div class="koruma-stats-grid">
        <div class="koruma-stat-card">
            <div class="stat-icon threat">⚠️</div>
            <div class="stat-content">
                <div class="stat-value" id="stat-threats-today"><?php echo esc_html($stats['threats_today']); ?></div>
                <div class="stat-label"><?php _e('Bugün Tespit Edilen Tehdit', 'koruma'); ?></div>
            </div>
        </div>
        <div class="koruma-stat-card">
            <div class="stat-icon week">📊</div>
            <div class="stat-content">
                <div class="stat-value" id="stat-threats-week"><?php echo esc_html($stats['threats_week']); ?></div>
                <div class="stat-label"><?php _e('Bu Hafta Tespit Edilen Tehdit', 'koruma'); ?></div>
            </div>
        </div>
        <div class="koruma-stat-card">
            <div class="stat-icon blocked">🚫</div>
            <div class="stat-content">
                <div class="stat-value" id="stat-blocked"><?php echo esc_html($stats['blocked_attempts']); ?></div>
                <div class="stat-label"><?php _e('Engellenen Deneme', 'koruma'); ?></div>
            </div>
        </div>
        <div class="koruma-stat-card">
            <div class="stat-icon total">📝</div>
            <div class="stat-content">
                <div class="stat-value" id="stat-total"><?php echo esc_html($stats['total_logs']); ?></div>
                <div class="stat-label"><?php _e('Toplam Log Kaydı', 'koruma'); ?></div>
            </div>
        </div>
    </div>

    <!-- Tarama -->
    <div class="koruma-card">
        <div class="koruma-card-header">
            <h2><?php _e('Dosya Taraması', 'koruma'); ?></h2>
        </div>
        <div class="koruma-card-body">
            <p><?php _e('Tüm dosyalarınızı tarayarak virüs ve şüpheli kodları tespit edin.', 'koruma'); ?></p>
            <button type="button" class="koruma-btn koruma-btn-primary" id="koruma-scan-btn">
                <span class="btn-icon">🔍</span>
                <?php _e('Taramayı Başlat', 'koruma'); ?>
            </button>
            <div id="koruma-scan-progress" class="koruma-progress" style="display: none;">
                <div class="progress-bar">
                    <div class="progress-fill"></div>
                </div>
                <p class="progress-text"><?php _e('Taranıyor...', 'koruma'); ?></p>
            </div>
        </div>
    </div>

    <!-- Tarama Sonuçları -->
    <div class="koruma-card" id="koruma-scan-results" style="display: none;">
        <div class="koruma-card-header">
            <h2><?php _e('Tarama Sonuçları', 'koruma'); ?></h2>
            <span class="threat-count" id="threat-count">0</span>
        </div>
        <div class="koruma-card-body">
            <div id="koruma-threats-list" class="koruma-threats-list">
                <!-- Tehditler buraya eklenecek -->
            </div>
        </div>
    </div>

    <!-- Loglar -->
    <div class="koruma-card">
        <div class="koruma-card-header">
            <h2><?php _e('Güvenlik Logları', 'koruma'); ?></h2>
            <button type="button" class="koruma-btn koruma-btn-secondary koruma-btn-sm" id="koruma-clear-logs-btn">
                <?php _e('Logları Temizle', 'koruma'); ?>
            </button>
        </div>
        <div class="koruma-card-body">
            <div class="koruma-logs-container">
                <table class="koruma-logs-table">
                    <thead>
                        <tr>
                            <th><?php _e('Tarih', 'koruma'); ?></th>
                            <th><?php _e('Olay Tipi', 'koruma'); ?></th>
                            <th><?php _e('Mesaj', 'koruma'); ?></th>
                            <th><?php _e('IP Adresi', 'koruma'); ?></th>
                        </tr>
                    </thead>
                    <tbody id="koruma-logs-tbody">
                        <?php if (!empty($recent_logs)): ?>
                            <?php foreach ($recent_logs as $log): ?>
                                <tr>
                                    <td><?php echo esc_html(date_i18n('d.m.Y H:i', strtotime($log['created_at']))); ?></td>
                                    <td><span class="log-type log-type-<?php echo esc_attr($log['event_type']); ?>"><?php echo esc_html($log['event_type']); ?></span></td>
                                    <td><?php echo esc_html($log['message']); ?></td>
                                    <td><?php echo esc_html($log['ip_address']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" class="no-logs"><?php _e('Henüz log kaydı yok', 'koruma'); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Tehdit Detay Modal -->
<div id="koruma-threat-modal" class="koruma-modal">
    <div class="koruma-modal-content">
        <div class="koruma-modal-header">
            <h3><?php _e('Tehdit Detayları', 'koruma'); ?></h3>
            <button class="koruma-modal-close">&times;</button>
        </div>
        <div class="koruma-modal-body" id="koruma-threat-details">
            <!-- Tehdit detayları buraya eklenecek -->
        </div>
    </div>
</div>

