<tr valign="top">
    <th scope="row" class="titledesc">
        <label for="<?php echo esc_attr( $option->get_id_attribute() ); ?>"><?php echo esc_html( $option->get_label() ); ?></label>
    </th>
    <td class="forminp forminp-text">
        <select id="<?php echo esc_attr( $option->get_id_attribute() ); ?>" name="<?php echo esc_attr($option->get_name_attribute()); ?>" multiple>
            <?php foreach ($option->args['options'] as $key => $label) { ?>
                <option value="<?php echo esc_attr( $key ); ?>" <?php echo in_array($key, $option->get_value_attribute()) ? 'selected' : null; ?>><?php echo esc_html( $label ); ?></option>
            <?php } ?>
        </select>
        <?php if($description = $option->get_arg('description')) { ?>
            <p class="description"><?php echo esc_html( $description ); ?></p>
        <?php } ?>

        <?php if($error = $option->has_error()) { ?>
            <div class="wps-error-feedback"><?php echo esc_html( $error ); ?></div>
        <?php } ?>
    </td>
</tr>
